import rpyc

def main():

# This is the simple connect call if you're ok with the remote traceback
#    conn = rpyc.connect("localhost", 18861)
# This one suppresses the traceback - we still print the exception
    conn = rpyc.connect(
        "localhost",
        18861,
        config={"include_local_traceback": False},
    )

    print("RPyC Calculator Client")
    print("=" * 40)

    # The service "root" is the remote object now
    calc = conn.root

    result = calc.add(5, 3)
    print(f"add(5, 3) = {result}")

    result = calc.subtract(10, 4)
    print(f"subtract(10, 4) = {result}")

    result = calc.multiply(7, 6)
    print(f"multiply(7, 6) = {result}")

    result = calc.divide(15, 3)
    print(f"divide(15, 3) = {result}")

    print("\nCalculation history:")
    for entry in calc.get_history():
        print(f"  {entry}")

    print("\nTesting error handling:")
    try:
        result = calc.divide(10, 0)
        print(f"divide(10, 0) = {result}")
    except Exception as e:
        # print only the exception's message to avoid a "<traceback denied>" message
        msg = e.args[0] if e.args else str(e)
        print(f"Error: {msg}")

    conn.close()


if __name__ == "__main__":
    main()
