from xmlrpc.client import ServerProxy


def main():
    # Connect to the server
    # ServerProxy creates a proxy object that forwards method calls to the server
    server = ServerProxy('http://localhost:8000')
    
    print("XML-RPC Calculator Client")
    print("=" * 40)
    
    # Call remote methods
    # These look like local method calls but execute on the server
    result = server.add(5, 3)
    print(f"add(5, 3) = {result}")
    
    result = server.subtract(10, 4)
    print(f"subtract(10, 4) = {result}")
    
    result = server.multiply(7, 6)
    print(f"multiply(7, 6) = {result}")
    
    result = server.divide(15, 3)
    print(f"divide(15, 3) = {result}")
    
    # Error handling
    print("\nTesting error handling:")
    try:
        result = server.divide(10, 0)
        print(f"divide(10, 0) = {result}")
    except Exception as e:
        print(f"Error: {e}")


if __name__ == '__main__':
    main()

