import java.io.*;
import java.net.*;

public class UdpClient {
    public static void main(String[] args) throws IOException {
        String host = "127.0.0.1";
        int port = 8080;

        try (DatagramSocket socket = new DatagramSocket()) {
            InetAddress address = InetAddress.getByName(host);

            byte[] message = "Hello from UDP client".getBytes();
            DatagramPacket request = new DatagramPacket(
                message, message.length, address, port);
            socket.send(request);

            byte[] buffer = new byte[1024];
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);

            String reply = new String(response.getData(), 0, response.getLength());
            System.out.println("Received: " + reply);
        }
    }
}
