import java.io.*;
import java.net.*;

public class UdpServer {
    public static void main(String[] args) throws IOException {
        int port = 8080;
        byte[] buffer = new byte[1024];

        try (DatagramSocket socket = new DatagramSocket(port)) {
            System.out.println("UDP server listening on port " + port);

            while (true) {
                DatagramPacket request = new DatagramPacket(buffer, buffer.length);
                socket.receive(request);

                String message = new String(request.getData(), 0, request.getLength());
                System.out.println("Received: " + message);

                byte[] response = "Message received".getBytes();
                DatagramPacket reply = new DatagramPacket(
                    response, response.length,
                    request.getAddress(), request.getPort());
                socket.send(reply);
            }
        }
    }
}
